;----------------------------------------------------------------
; constants
;----------------------------------------------------------------

PRG_COUNT = 2 ;1 = 16KB, 2 = 32KB
CHR_COUNT = 4 ;1 = 8KB, 2 = 16KB, 4 = 32KB
MIRRORING = %0000 ;%0000 = horizontal, %0001 = vertical, %1000 = four-screen

;----------------------------------------------------------------
; variables
;----------------------------------------------------------------

   .enum $0000

   ;NOTE: declare variables using the DSB and DSW directives, like this:

   ;MyVariable0 .dsb 1
   ;MyVariable1 .dsb 3

   byte_0     .dsb 1
   byte_1     .dsb 1
   byte_2     .dsb 1
   byte_3     .dsb 1
   byte_4     .dsb 1
   byte_5     .dsb 1
   byte_6     .dsb 1
   byte_7     .dsb 1
   byte_8     .dsb 1
   byte_9     .dsb 1
   byte_a     .dsb 1
   byte_b     .dsb 1
   byte_c     .dsb 1
   byte_d     .dsb 1
   byte_e     .dsb 1
   byte_f     .dsb 1
   NMISaveX   .dsb 1
   NMISaveY   .dsb 1
   byte_12    .dsb 1
   byte_13    .dsb 1
   byte_14    .dsb 1
   byte_15    .dsb 1
   byte_16    .dsb 1
   byte_17    .dsb 1
   byte_18    .dsb 1
   byte_19    .dsb 1
   byte_1a    .dsb 1
   byte_1b    .dsb 1
   byte_1c    .dsb 1
   byte_1d    .dsb 1
   Scroll_X   .dsb 1
   Scroll_Y   .dsb 1

      

   .ende


   .enum $078
   byte_78    .dsb 1
   .ende


   .enum $07D
   NewBank    .dsb 1
   .ende
   

   ;NOTE: you can also split the variable declarations into individual pages, like this:

   ;.enum $0100
   ;.ende

   ;.enum $0200
   ;.ende

   .enum  $0300
   
   SoftPPUCTRL   .dsb 1
   SoftPPUMASK   .dsb 1  
   
   .ende

   .enum $03E4
   byte_3E4      .dsb 1
   .ende

   .enum $2000 ;  -------------- PPU Registers ------------------
   
   PPUCTRL       .dsb 1
   PPUMASK       .dsb 1   
   PPUSTATUS     .dsb 1
   OAMADDR       .dsb 1
   OAMDATA       .dsb 1
   PPUSCROLL     .dsb 1
   PPUADDR       .dsb 1
   PPUDATA       .dsb 1

   .ende

   .enum $4014 ; -------------- ------------------
   OAMDMA        .dsb 1
   .ende
  

;----------------------------------------------------------------
; iNES header
;----------------------------------------------------------------

   .db "NES", $1a ;identification of the iNES header
   .db PRG_COUNT ;number of 16KB PRG-ROM pages
   .db CHR_COUNT ;number of 8KB CHR-ROM pages
   .db $30|MIRRORING ;mapper 3 and mirroring
   .dsb 9, $00 ;clear the remaining bytes

;----------------------------------------------------------------
; program bank(s)
;----------------------------------------------------------------

   .base $10000-(PRG_COUNT*$4000)

NMI:
   ;NOTE: NMI code goes here
  
  STX     NMISaveX
  STY     NMISaveY
  PHA



  LDA     SoftPPUCTRL
  AND     #%01111111
  TAY                     ; save PPUCTRL value
  STA     SoftPPUCTRL
  STA     PPUCTRL         ; Zero out the top bit to turn off NMI on vertical blank




  LDA     SoftPPUMASK
  AND     #%11100111
  STA     PPUMASK         ; Turn off sprites and background




  LDX     Scroll_Y
  JSR     WritePPUSCROLL

  STY     PPUCTRL         ; rewrite PPUCTRL saved earlier


  LDA     #0           
  STA     OAMADDR         ; zero OAMADDR

  LDA     #2 
  STA     OAMDMA          ; copy page 2 to OAM (256 bytes)






  LDY     #1
  CPY     byte_1b    ; if * <= 1 then jsr
  BCS     +
  JSR     $8B7F
+



  LDA     $28
  AND     #4
  BEQ     +
  JSR     $8B51      ; if * & 0x04 == 0 then jsr
  JMP     ++
+

  LDA     #0         ; else
  STA     $29
++






  LDA     NewBank    ; if high bit of NewBank is NOT set then select new bank and set high bit
  BMI     +
  AND     #$03
  TAX
  LDA     MapperBanks, X
  STA     MapperBanks, X
  LDA     #$80
  STA     NewBank
+



  LDA     SoftPPUMASK
  STA     PPUMASK
  
  TSX
  TXA
  AND     #$1F
  CMP     #$08
  BCS     +
  BCC     NMIDone
+
  
  JSR     $8107

  LDA     byte_78
  TAX
  AND     #$02
  BNE     ++++
  LDA     #$10
  AND     byte_3E4
  BEQ     +
  TXA
  ROR     A
  BCC     +
  LDA     #$02
  ORA     byte_78
  STA     byte_78
  LDA     #$21
  JSR     $836F
  BPL     ++++
+
  JSR     $83C2
  LDX     #$07

- INC     $20,X
  DEX
  BPL     -
  
  JSR     $81DD
  JSR     $863C
  INC     $42C
  BNE     +
  INC     $42D
+

  INC     $43C
  BNE     +
  INC     $43D
+

  LDA     $57F
  CMP     #$C0
  BCC     ++
  ROR     A
  BCS     +++
  LDA     $3E4
  ASL     A
  BCC     +
  JSR     $831E
  BCS     +++
+
 
  ASL     A
  BCC     ++
  JSR     $80FF
  BCS     +++
++
  LDA     #$FE
  AND     $28
  STA     $28
+++
  JMP     +
++++
  INC     $22
+
  JSR     $84CE
  JSR     $837D


  LDA      $78
  AND     #$04
  BNE     NMIDone
  JSR     MusicHandler
NMIDone:


  LDX     NMISaveX
  LDY     NMISaveY

  LDA     SoftPPUCTRL
  ORA     #$80 
  STA     SoftPPUCTRL
  STA     PPUCTRL


  PLA
  RTI


  .org $80EF
MapperBanks:   .db $10, $11, $12, $13

  


; ----------------------------------------------------------------------------------------
; Pass in new Scroll Y Address to send to PPU in X

WritePPUSCROLL:

  LDA     PPUSTATUS       ; Read PPUSTATUS to reset address latch
  LDA     Scroll_X
  STA     PPUSCROLL
  STX     PPUSCROLL
  RTS


  .org $8C00

Reset:

   ;NOTE: initialization code goes here


IRQ:

   ;NOTE: IRQ code goes here


;----------------------------------------------------------------
; music code
;----------------------------------------------------------------

   .org $f000
MusicHandler:
  LDX    #$02

;----------------------------------------------------------------
; interrupt vectors
;----------------------------------------------------------------

   .org $fffa

   .dw NMI
   .dw Reset
   .dw IRQ

;----------------------------------------------------------------
; CHR-ROM banks
;----------------------------------------------------------------

   .incbin "tiles0.chr"
   .incbin "tiles1.chr"
   .incbin "tiles2.chr"
   .incbin "tiles3.chr"